/*{
  "DESCRIPTION": "Fade transition",
  "CREDIT": "Gre",
  "ISFVSN": "2",
  "CATEGORIES": [
    "Transition"
  ],
  "INPUTS": [
    {
      "NAME": "hasBeginTexture",
      "TYPE": "bool"
    },
    {
      "NAME": "transitionBeginImage",
      "TYPE": "image"
    },
    {
      "NAME": "transitionEndImage",
      "TYPE": "image"
    }
  ]
}*/

#define getFromColor(uv) (hasBeginTexture ? IMG_NORM_PIXEL(transitionBeginImage, uv) : vec4(0.))
#define getToColor(uv) IMG_NORM_PIXEL(transitionEndImage, uv)
#define progress transitionProgress

uniform float transitionProgress;
vec4 transition(vec2 uv);

void main()
{
  gl_FragColor = transition(isf_FragNormCoord);
}

vec4 transition (vec2 uv) {
  return mix(
    getFromColor(uv),
    getToColor(uv),
    progress
  );
}
